/****************************************************************************
* BACK OUT POLYTRAUMA CHANGES v1.1 - Feb. 2014 (PII)
****************************************************************************/

-- Backout of Change #1: DEF_35233 - PTRP - Residence (Discharge) DDL options are not displaying right options
UPDATE [TBI].[STD_TBIDISCHARGETO] SET [NAME] = 'Military Housing', [DESCRIPTION_TEXT] = 'Apartment, Barracks or House' WHERE CODE = 'MTH'
UPDATE [TBI].[STD_TBIDISCHARGETO] SET [NAME] = 'Military Hospital', [DESCRIPTION_TEXT] = 'Military Hospital (MTF)' WHERE CODE = 'MTF'

-- Backout of Change #2: DEF_35482 - PolyTrauma - "Physical Assault" should be directly above this section, set up as a drop down list in the same manner as Blast, Vehicle, Bullet, Other.
INSERT INTO [TBI].[STD_TBIINJURYLIST]([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], 
[UPDATEDBY], [CREATED], [UPDATED]) 
VALUES('Physical Assault', 'Physical Assault', 'Physical Assault', 18, 0, NULL, 'DNS   RYANK', 'DNS   RYANK', GETDATE(), GETDATE());

-- remove column for Physical Assault Injury
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'PHYS_ASSAULT_INJRY_IND')
ALTER TABLE [TBI].[TBI_POLYTRAUMA] DROP COLUMN [PHYS_ASSAULT_INJRY_IND];

-- Add column to TBI_POLYTRAUMA for PHYSICAL_ASSAULT_INJRY_IND
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'PHYSICAL_ASSAULT_INJRY_IND')
ALTER TABLE [TBI].[TBI_POLYTRAUMA] ADD [PHYSICAL_ASSAULT_INJRY_IND] varchar(1) NULL;

-- Backout of Change #3 for DEF_35481 - Set Walter Reed and National Naval to inactive.
UPDATE [TBI].[STD_TBIFACILITYSRC] SET [INACTIVE_FLAG] = 0, [INACTIVE_DATE] = NULL WHERE [ID] < 3;

-- Backout of Change #4 for Task 35576 - Create Database change scripts for additional discharge scores and defects.
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_ABILITIES_DC')
ALTER TABLE [TBI].[TBI_POLYTRAUMA] DROP COLUMN [MPAI_ABILITIES_DC]

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_ADJUSTMENT_DC')
ALTER TABLE [TBI].[TBI_POLYTRAUMA] DROP COLUMN [MPAI_ADJUSTMENT_DC]

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_PARTICIPATION_DC')
ALTER TABLE [TBI].[TBI_POLYTRAUMA] DROP COLUMN MPAI_PARTICIPATION_DC

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_TOTAL_DC')
ALTER TABLE [TBI].[TBI_POLYTRAUMA] DROP COLUMN MPAI_TOTAL_DC

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_Q26_DC')
ALTER TABLE [TBI].[TBI_POLYTRAUMA] DROP COLUMN MPAI_Q26_DC

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'SATIS_W_LIFE_DC')
ALTER TABLE [TBI].[TBI_POLYTRAUMA] DROP COLUMN SATIS_W_LIFE_DC

GO

-- Backout of Change #5 - Remove Military Duty Status at Discharge (duplicate field)
-- create new column for military duty status at discharge, and constraint for STD_TBIDSCHRGSTS
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'DC_MILITARY_DUTY_STATUS_ID')
BEGIN

ALTER TABLE TBI.TBI_POLYTRAUMA ADD DC_MILITARY_DUTY_STATUS_ID int NULL

ALTER TABLE TBI.TBI_POLYTRAUMA ADD CONSTRAINT
	FK_TBI_POLYTRAUMA_MILITARY_DUTY_STATUS_STD_TBIDSCHRGSTS FOREIGN KEY
	(
	DC_MILITARY_DUTY_STATUS_ID
	) REFERENCES TBI.STD_TBIDSCHRGSTS
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 

END
GO